---
title: Mengapa Aku Suka Dengan Terminal?
description: 
date: 2025-10-27
author: sheenazien8
tags: productivity, tips, terminal, cli, command line
image: https://sheenazien.my.id/blogs/mengapa-aku-suka-dengan-terminal/assets/featured.png
---

# Mengapa Aku Suka Dengan Terminal?

![Featured Image](assets/featured.png)

Kita sebagai developer akan selalu dekat dengan yang namanya terminal, tapi apakah kita sudah bisa memaksimalkannya dengan baik?.
Padahal terminal bisa membuat pekerjaan kita sebagai developer jauh lebih efisien tanpa pindah-pindah aplikasi, cukup browser dan terminal.

- Browser untuk browsing kebutuhan kita, dan atau lihat hasil pekerjaan kita
- Dan Terminal untuk semua hal yang kita lakukan

## Apa Aja Sih Tools Tools yang Biasanya Saya Pakai?

1. **neovim**
Tentu saja para developer yang suka dengan terminal pastinya tidak asing dengan editor teks ini, 
karena neovim memberikan pengalaman yang bisa full "terminal", tetapi jangan pernah meremehkan neovim ini, 
kebanyakan fitur yang sudah bisa dilakukan di editor teks mainstream bisa di lakukan di neovim, 
seperti autocomplete, snippet, syntaks highliting, dan masih banyak lagi.

2. **tmux**
Dan tidak lupa tmux, tidak etis rasanya jika kita sudah bicara tentang neovim tapi tidak juga bicara tentang tmux ini. Tmux adalah terminal multiplexer atau *session manager* -- ia membiarkanmu membuka banyak panel, jendela, dan sesi terminal di satu layar.
Neovim ini tidak mendukung secara default menyimpan folder terakhir yang kamu buka seperti di editor teks lainnya seperti VS Code, dan untuk itu tmux dipadukan dengan neovim.

3. **httpie**
HTTPie adalah command-line HTTP client yang membuat interaksi CLI dengan web services menjadi lebih user-friendly. Dengan syntax yang intuitif, HTTPie memungkinkan kita untuk melakukan request HTTP tanpa perlu menggunakan curl yang rumit. Misalnya, untuk GET request cukup `http example.com`, dan untuk POST `http POST example.com name=value`.

4. **jq**
jq adalah command-line JSON processor yang ringan dan fleksibel. Alat ini sangat berguna untuk memproses dan memanipulasi data JSON langsung dari terminal. Kita bisa filter, transform, dan query JSON data dengan mudah. Contohnya, untuk extract field tertentu: `cat data.json | jq '.users[].name'`.

5. **fx**
fx adalah terminal JSON viewer dan command-line tool yang interaktif. Berbeda dengan jq yang lebih untuk processing, fx lebih fokus pada visualisasi dan eksplorasi data JSON. Kita bisa browse JSON seperti file explorer, dan bahkan edit langsung di terminal.

6. **bash script**
Dan yang terakhir, bash scripting untuk automation. Dengan bash, kita bisa membuat script untuk automate repetitive tasks. Mulai dari simple backup script, sampai complex deployment pipelines. Terminal memungkinkan kita untuk chaining commands dan membuat workflow yang powerful.

## Kenapa Terminal Bisa Bikin Efisien?

Terminal memberikan kontrol penuh atas sistem kita. Kita tidak terbatas pada GUI yang kadang-kadang lambat dan membuang resource. Dengan keyboard shortcuts dan command composition, kita bisa bekerja lebih cepat.

Selain itu, terminal adalah universal. Commands yang kita pelajari di satu sistem bisa digunakan di sistem lain. Dan yang paling penting, terminal memungkinkan kita untuk automate everything. Dari git operations sampai deployment, semuanya bisa di-script dan di-repeat tanpa error.

## Tips Menggunakan Terminal

- Pelajari basic commands dulu: ls, cd, grep, find, sed, awk
- Gunakan alias untuk commands yang sering dipakai
- Pelajari piping dan redirection (|, >, <)
- Install tools seperti fzf untuk fuzzy finding
- Buat script untuk tasks repetitive

## Kesimpulan

Terminal bukan hanya tool, tapi mindset. Dengan terminal, kita sebagai developer bisa lebih productive dan efficient. Kita bisa focus pada logic dan code, bukan pada interface. Jika belum familiar, mulai dari basic dan explore step by step. Terminal akan menjadi best friend kita dalam development journey.

Dan ini adalah contoh alur kerja di dunia nyata yang biasa aku gunakan setiap hari.

```bash
# Api login
http :8080/api/auth/login < login.json | jq -r .data.token > token.txt

# Ambil response data dari api dengan Authorization Bearer dan menampilkan responsenya dengan fx
http -A bearer -a $(cat token.txt) :8080/auth/profile | fx

# Terakhir kamu bisa membuat script untuk mengotomasi itu dengan bash script

```
