---
title: Why I Love With Terminal?
description: 
date: 2025-10-27
author: sheenazien8
tags: productivity, tips, terminal, cli, command line
image: https://sheenazien.my.id/blogs/mengapa-aku-suka-dengan-terminal/assets/featured.png
---

# Why I Love With Terminal?

![Featured Image](assets/featured.png)


## Introduction

As developers, we're always close to the terminal, but are we maximizing its potential? The terminal can make our work as developers much more efficient without switching between applications - just a browser and terminal.

- Browser for browsing our needs and viewing our work results
- Terminal for everything else we do

## What Tools Do I Usually Use?

1. **neovim**
Of course, developers who love the terminal are familiar with this text editor. Neovim provides a full "terminal" experience, but don't underestimate it - most features available in mainstream text editors can be done in neovim, like autocomplete, snippets, syntax highlighting, and much more.

2. **tmux**
And of course tmux. It wouldn't be right to talk about neovim without mentioning tmux. Tmux is a terminal multiplexer or session manager - it lets you open multiple panels, windows, and terminal sessions on one screen. Neovim doesn't support saving the last opened folder by default like other text editors such as VS Code, which is why tmux is paired with neovim.

3. **httpie**
HTTPie is a command-line HTTP client that makes CLI interaction with web services as human-friendly as possible. With intuitive syntax, HTTPie allows us to make HTTP requests without using complicated curl. For example, for a GET request just `http example.com`, and for POST `http POST example.com name=value`.

4. **jq**
jq is a lightweight and flexible command-line JSON processor. This tool is very useful for processing and manipulating JSON data directly from the terminal. We can filter, transform, and query JSON data easily. For example, to extract a specific field: `cat data.json | jq '.users[].name'`.

5. **fx**
fx is an interactive terminal JSON viewer and command-line tool. Unlike jq which is more for processing, fx focuses more on visualization and exploration of JSON data. We can browse JSON like a file explorer, and even edit directly in the terminal.

6. **bash script**
And finally, bash scripting for automation. With bash, we can create scripts to automate repetitive tasks. From simple backup scripts to complex deployment pipelines. The terminal allows us to chain commands and create powerful workflows.

## Why Can Terminal Make Us Efficient?

The terminal gives us full control over our system. We're not limited by GUIs that can sometimes be slow and waste resources. With keyboard shortcuts and command composition, we can work faster.

Moreover, the terminal is universal. Commands we learn on one system can be used on another system. And most importantly, the terminal allows us to automate everything. From git operations to deployment, everything can be scripted and repeated without errors.

## Tips for Using Terminal

- Learn basic commands first: ls, cd, grep, find, sed, awk
- Use aliases for frequently used commands
- Learn piping and redirection (|, >, <)
- Install tools like fzf for fuzzy finding
- Create scripts for repetitive tasks

## Conclusion

The terminal is not just a tool, but a mindset. With the terminal, we as developers can be more productive and efficient. We can focus on logic and code, not on interfaces. If you're not familiar yet, start with the basics and explore step by step. The terminal will become our best friend in our development journey.

And this is an example of a real-world workflow that I use every day.

```bash
# API login
http :8080/api/auth/login < login.json | jq -r .data.token > token.txt

# Get response from api with Authorization Bearer and show the response using fx
http -A bearer -a $(cat token.txt) :8080/auth/profile | fx

# Lastly you only need create script for automating that with bash script

```
